%This function returns the boundaries of the model for the localization
% to use according to slice and part of the model (CA, DG)

function [min max mean shift] = get_models_std(slice, part)

    if part == 1
        shift = [ -pi/2 50; -pi/4 50; -pi/4 50;  0     60;  pi/4  50;  pi/4  50;   pi/2  50];
        if slice == 26
            min  = [  0.2571  -0.2090   0.2914   0.4055   2.3192  -3.1271   2.7663   300.0000   54.1479   77.5603   65.7951   41.7805   49.9222   35.4591];
            max  = [  1.3083   0.2756   0.4850   0.7121   3.0749  -2.8105   3.1499   800.0000  127.0043  130.5388  139.3315   87.3893  102.8924   86.4002];
            mean = [          -0.0085   0.4036   0.5555   2.8076  -2.8873   2.8201              97.2812  102.1567  106.1037   57.3149   87.0671   48.1741];
        elseif slice == 28
            min  = [  0.2571  -0.3717  -0.0280   0.3730   2.5597  -3.0251   2.8133   300.0000   69.6175   90.6596   88.5103   60.5078   67.1195   53.0750];
            max  = [  1.3083   0.1121   0.4187   0.6655   3.0861  -2.7166   3.2491   800.0000  124.9390  133.2272  144.6595   84.1756  102.0748   87.4160];
            mean = [          -0.2614   0.1888   0.4677   2.8785  -2.8940   2.9669             106.3586  111.1610  104.3148   68.4334   91.2576   68.9842];
        elseif slice == 30
            min  = [  0.2571  -0.3587  -0.1473   0.2078   2.7098   2.9419   2.5643   300.0000   78.7066   86.6408   88.8094   65.6079   73.2696   57.1187];
            max  = [  1.3083   0.0501   0.3724   0.5717   3.1162   3.5663   3.2489   800.0000  124.5417  133.8867  140.7252  100.5725  104.1074   87.5666];
            mean = [          -0.2044   0.1148   0.4671   2.8967   3.3532   2.9241              92.9782  113.4241  103.3002   76.1533   87.9276   70.6386];
        elseif slice == 32
            min  = [  0.2571  -0.4876  -0.1974   0.0611   2.5981   2.8833   2.4228   300.0000   67.4588   72.9279   84.8183   61.8853   73.9279   55.7170];
            max  = [  1.3083  -0.0640   0.3935   0.4416   3.0966   3.4016   2.7659   800.0000  120.1688  104.6175  126.6501  115.9578   95.0339  100.3947];
            mean = [          -0.2554   0.0471   0.2292   2.7001   3.3000   2.5988              81.6551   84.7975   97.4159   78.3082   78.3962   63.2331];
        elseif slice == 34
            min  = [  0.2571  -0.7246  -0.2015   0.0168   2.5024   2.8621   2.3973   300.0000   71.4678   62.5328   74.5991   71.0000   93.5939   51.6624];
            max  = [  1.3083  -0.3347   0.2650   0.5060   3.1416   2.9876   2.7192   800.0000  132.4824  107.2007  149.6621  134.0821  117.3882  105.3945];
            mean = [          -0.4836   0.0818   0.1734   2.8547   2.9286   2.5511              81.2937   81.0843   99.5646   99.7117  101.4898   69.5283];
        elseif slice == 36
            min  = [  0.2571  -0.6082  -0.0105  -0.0180   2.7261   2.6562   2.4023   300.0000   67.9117   60.8276   65.7875   76.9415   77.9524   78.0060];
            max  = [  1.3083  -0.0251   0.4305   0.4266   3.0437   3.1128   2.7993   800.0000  135.0296  118.2286  112.0045  136.1249  107.8378  111.2520];
            mean = [          -0.3821   0.1833   0.1497   2.8378   2.9155   2.5852              81.7948   75.6189   80.8648   87.3054   90.7779   88.9339];
        elseif slice == 38
            min  = [  0.2571  -0.7162  -0.1998  -0.0941   2.5989   2.6899   2.4711   300.0000   54.5310   65.0267   61.2722   73.7257   68.7257   78.7878];
            max  = [  1.3083   0.1226   0.3604   0.3693   2.9960   3.1278   2.8267   800.0000   95.4225  104.0000  122.5887  130.2340  112.2586  114.8261];
            mean = [          -0.4483   0.0224   0.1111   2.7319   2.9188   2.5793              71.1993   85.5460   87.1339   89.6235   85.1370   91.2244];
        elseif slice == 40
            min  = [  0.2571  -0.5124  -0.2709  -0.2096   2.3996   2.5198   2.7105   300.0000   51.7791   53.1171   47.5537   67.3222   70.3042   77.1686];
            max  = [  1.3083   0.0733   0.3393   0.6132   2.9937   2.9604   3.0264   800.0000   93.0339   78.7829   87.0673  105.3302  110.7953  108.2030];
            mean = [          -0.2618   0.0729   0.1498   2.6645   2.7271   2.8085              71.8834   68.1077   77.3546   82.6888   84.3921   89.3936];
        elseif slice == 42
            min  = [  0.2571  -0.2046  -0.1283  -0.0235   2.4228   2.7281   2.6451   300.0000   37.1295   41.1566   44.8197   90.7359   83.0922   57.2896];
            max  = [  1.3083   0.0500   0.1694   0.2687   2.7520   2.8260   3.1416   800.0000   81.0494   81.0247   85.0235  130.3610  111.4907  117.1537];
            mean = [          -0.0904   0.0208   0.1186   2.5858   2.7764   2.9400              52.8585   62.4645   63.9234   97.1976   94.2549   72.7994];
        elseif slice == 44
            min  = [  0.2571  -0.20    -0.1555  -0.1244   2.5651   2.7196   2.8828   300.0000   37.7927   33.1568   31.1611   55.5347   67.0064   57.5273];
            max  = [  1.3083   0.1194   0.1228   0.5779   2.8431   3.1032   3.1208   800.0000   81.5385   74.8190   75.5047  114.7220   99.7852  105.4509];
            mean = [           0.0690   0.0193   0.2526   2.3851   2.8877   3.0283              51.9732   55.9373   58.5809   71.2752   75.0557   77.6122];
        else
            error('Slice not available.');
        end
    elseif part == 2
        shift = [ 0        35;  -pi/4    35;  -pi/2    35;  -3*pi/4  35;  -3*pi/4  35;  -3*pi/4  35;  -pi      35;  -3*pi/2  35];
        if slice == 26
            min  = [  0.0813  -2.6955  -3.0556   2.8334   2.6088   2.1184   1.5839   0.6842  250.0000   26.0355   37.9262   55.4313   85.9192   85.7747   80.7419   86.6391];
            max  = [  0.9143  -2.4926  -2.6779   3.0585   2.8130   2.6012   2.0011   1.2849 1100.0000   77.8465   87.3773   81.9353  151.4461  143.9755  133.2373  120.7206];
            mean = [          -2.6036  -2.9322   3.0007   2.6900   2.3244   1.7791   0.8589             48.0369   55.4475   64.2138  106.0588  110.5951   98.2864  107.0422];
        elseif slice == 28
            min  = [  0.0813  -2.6867  -3.0607   2.8535   2.4930   2.0731   1.5594   0.7026  250.0000   54.0994   44.1694   58.5911   79.7618   86.2081   80.2038   84.3644];
            max  = [  0.9143  -2.4933  -2.9341   3.0484   2.7960   2.5055   2.1014   1.2077 1100.0000   75.0469   58.2859  102.4194  116.7745  162.7025  122.9032  127.9477];
            mean = [          -2.5472  -2.9835   2.9157   2.6543   2.3199   1.8536   0.8659             64.1129   53.8921   71.8364  100.9523  119.2166   97.6930  103.9383];
        elseif slice == 30
            min  = [  0.0813  -2.7611  -3.0367   2.8324   2.3932   2.2062   1.6808   0.8595  250.0000   49.1491   51.3508   61.8258  107.8777   85.0119   71.8071   81.4026];
            max  = [  0.9143  -2.3184  -2.9141   3.0029   2.7364   2.4251   2.1381   1.3041 1100.0000   78.4663   78.4663   87.8920  131.5784  153.4060  113.1588  109.1720];
            mean = [          -2.5592  -2.9664   2.9365   2.4705   2.3273   1.9281   0.9375             64.4260   67.9443   76.0061  123.4353  101.3438   87.1101   96.8079];
        elseif slice == 32
            min  = [  0.0813  -2.7018  -3.1237   2.7118   2.4949   2.2102   1.7578   1.0300  250.0000   56.4001   50.4266   57.7617  107.5126   72.2012   57.5198   66.8219];
            max  = [  0.9143  -2.3036  -2.8198   3.0211   2.7146   2.3856   2.1137   1.4503 1100.0000   85.7722   85.4349   94.2143  165.4077  145.8924  121.7252  113.7747];
            mean = [          -2.5311  -2.9828   2.8172   2.5994   2.2775   1.9026   1.1199             71.1813   67.6654   77.6638  137.5826  108.2412   99.2209   92.3558];
        elseif slice == 34
            min  = [  0.0813  -2.5373  -2.9683   2.8517   2.5718   2.2581   1.8473   0.8983  250.0000   64.8190   59.7554   69.9025   96.2709   93.6133   85.9738   88.0579];
            max  = [  0.9143  -2.1984  -2.7928   3.0309   2.7681   2.4586   2.1281   1.5006 1100.0000   96.7261   73.3005   95.7429  138.7455  149.6504  122.0291  110.4695];
            mean = [          -2.3725  -2.8724   2.9466   2.6585   2.3567   1.9903   1.1100             81.8308   64.6285   83.2657  117.0010  120.5571  106.9791  100.9118];
        elseif slice == 36
            min  = [  0.0813  -2.5546  -2.9699   2.8551   2.4067   2.1021   1.5339   0.8908   250.000   73.4199   65.4463   67.5610   76.1758   88.0278   74.0625   56.7083];
            max  = [  0.9143  -1.9890  -2.7799   3.0080   2.7219   2.4269   2.1025   1.3387  1100.000  128.2214   92.0489  104.8220  155.1856  142.2309  150.6154   99.7296];
            mean = [          -2.2685  -2.8595   2.9493   2.6084   2.2969   1.7889   1.0572            104.4750   77.0499   85.9670  117.5226  121.5096  114.4938   81.9256];
        elseif slice == 38
            min  = [  0.0813  -2.3717  -2.9521   2.6675   2.2902   2.0797   1.7382   0.9697  250.0000   82.8021   49.0408   61.8401   96.0469   90.6863   72.0069   43.8840];
            max  = [  0.9143  -2.1064  -2.4573   3.0090   2.6805   2.3731   2.1431   1.2908 1100.0000  151.7560   89.8888  104.7855  166.4934  142.1443  130.1606  105.4513];
            mean = [          -2.2185  -2.7816   2.8404   2.4704   2.2185   1.8762   1.0953            123.4577   74.0511   85.1155  118.9405  105.1711  100.0996   79.9248];
        elseif slice == 40
            min  = [  0.0813  -2.8291  -3.1160   2.7578   2.2988   2.1666   1.8055   0.8404  250.0000   68.5848   58.5558   69.9325   68.6932   76.4153   64.9025   58.7489];
            max  = [  0.9143  -2.1889  -2.5703   2.9649   2.6022   2.5365   1.9760   1.3125 1100.0000  126.9734   85.2867  100.9192  135.9986  116.9886  109.2550   88.2782];
            mean = [          -2.4863  -2.8501   2.8483   2.4083   2.2764   1.8584   1.1750             95.6324   66.0559   82.8405   92.1985   87.8094   78.5396   74.7261];
        elseif slice == 42
            min  = [  0.0813  -2.8638  -3.0305   2.7113   2.3127   2.2318   1.6021   0.8077  250.0000   74.6543   54.2418   73.3894   64.8749   54.1786   51.9775   47.5731];
            max  = [  0.9143  -2.2595  -2.6125   2.9947   2.8798   2.7981   2.1944   1.4315 1100.0000  118.9440   95.9607  100.7419  145.9988   98.4689   92.4160   90.3061];
            mean = [          -2.4961  -2.8449   2.8172   2.5443   2.4191   1.9740   1.1045            107.6015   76.5699   81.3672  102.6994   73.9298   63.4587   55.3150];
        elseif slice == 44
            min  = [  0.0813  -2.9247  -2.9640   2.7131   2.5076   2.4359   1.9033   1.0475  250.0000   60.4116   59.4720   73.3042   63.3424   59.9812   53.2992   45.0532];
            max  = [  0.9143  -2.2034  -2.5234   3.0150   2.8966   2.8253   2.2974   1.6208 1100.0000  117.1213   88.6383  123.2175   92.4388  112.0307   80.1703   63.8853];
            mean = [          -2.7473  -2.8258   2.9259   2.6759   2.6895   2.0668   1.3857             92.0504   71.2695   82.9014   78.7212   80.5481   67.6383   54.8830];
        else
            error('Slice not available.');
        end
    else
        error('Part not available.');
    end
end
